--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNshapeParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCshape

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNshapeParams FUNshape FUNspline =
  (
    if FUNshape != undefined then
    (
      if classof FUNshape == PolymorphicGeomshape then
      (
        for i in DYNshapeParams.controls do i.visible = false
        DYNshapeParams.BUDYNupdate.visible = true
        DYNshapeParams.BUDYNupdate.pos.y = 27
        DYNshapeParams.LBDYNlength01.visible = true
        DYNshapeParams.LBDYNlength01.pos = [5,7]
        DYNshapeParams.LBDYNlength01.text = DYNuiResourcesLabels[193]
        DYNshapeParams.height = 58
      )
      else
      (
        local LOCappData424 = (getAppData FUNshape 424) as string
        --- Force repair of AppData 428 to solve potential problems associated with the updating of strings originally imported in V3 Beta when
        --- MX Model Names were not correctly trimmed of blank spaces if imported via MX Model Files
        if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
        (
          setAppData FUNshape 428 (DYNFUNstripStringSpaces (subString (getAppData FUNshape 428) 1 28))
        )

        --- Continue Loading Shape Object
        local LOCnumKnots    = numKnots FUNshape
        if LOCnumKnots > 1 then
        (
          --- Display Spline/Knot Information
          local LOCcurveLng    = 0.0
          local LOCnumSplines  = try (numSplines FUNshape) catch (1)
          local LOCmultSplines = if LOCnumSplines == 1 then false else true

          for i = 1 to LOCnumSplines do LOCcurveLng += curveLength FUNshape i

          local LOCcurveLngSel = curveLength FUNshape FUNspline
          local LOCnumKnotsSel = numKnots FUNshape FUNspline
          local LOCisClosedSel = try (isClosed FUNshape FUNspline) catch (undefined)
          local LOCisClosedTxt = if LOCisClosedSel == undefined then "" else (if LOCisClosedSel then " (Closed)" else " (Open)")

          LOClengthUnit = " "
          if units.systemType == #inches      then LOClengthUnit += DYNuiResourcesUnitsDistance[8]
          if units.systemType == #feet        then LOClengthUnit += DYNuiResourcesUnitsDistance[7]
          if units.systemType == #miles       then LOClengthUnit += DYNuiResourcesUnitsDistance[6]
          if units.systemType == #millimeters then LOClengthUnit += DYNuiResourcesUnitsDistance[5]
          if units.systemType == #centimeters then LOClengthUnit += DYNuiResourcesUnitsDistance[4]
          if units.systemType == #meters      then LOClengthUnit += DYNuiResourcesUnitsDistance[2]
          if units.systemType == #kilometers  then LOClengthUnit += DYNuiResourcesUnitsDistance[3]

          DYNshapeParams.LBDYNlength01.text  = DYNuiResourcesLabels[194] + "  " + (LOCcurveLng as string) + LOClengthUnit
          DYNshapeParams.LBDYNpoints01.text  = DYNuiResourcesLabels[122] + "  " + (LOCnumKnots as string)
          DYNshapeParams.LBDYNspline01.text  = DYNuiResourcesLabels[196] + "  " + (LOCnumSplines as string)
          DYNshapeParams.LBDYNlength02.text  = DYNuiResourcesLabels[28]  + "  " + (LOCcurveLngSel as string) + LOClengthUnit + LOCisClosedTxt
          DYNshapeParams.LBDYNpoints02.text  = DYNuiResourcesLabels[122] + "  " + (LOCnumKnotsSel as string)
          DYNshapeParams.SPDYNspline.range   = [1,LOCnumSplines,FUNspline]
          DYNshapeParams.SPDYNspline.enabled = LOCmultSplines

          --- Display Source Information
          if (getAppData FUNshape 422) == "7" then
          (
            DYNshapeParams.LBDYNmodel02.text   = DYNFUNdisplayAppDataInUI ((getAppData FUNshape 428) as string)
            DYNshapeParams.LBDYNstring02.text  = DYNFUNdisplayAppDataInUI ((getAppData FUNshape 427) as string)
            DYNshapeParams.LBDYNimported.text  = DYNFUNconvertGUPdate     ((getAppData FUNshape 425) as string)
            DYNshapeParams.LBDYNsource.text    = filenameFromPath LOCappData424

            if doesFileExist LOCappData424 then
            (
              if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
              (
                --- For Model Files
                local LOCmodelName      = (getAppData FUNshape 428) as string; while LOCmodelName.count < 28 do LOCmodelName += " "
                local LOCmxModelmodDate = DYNFUNgetMxModelFileModelModifyTime LOCappData424 LOCmodelName
                DYNshapeParams.LBDYNmodify02.text  = if classOf LOCmxModelmodDate == string then DYNFUNconvertGUPdate LOCmxModelmodDate
              )
              else
              (
                --- For other file types
                DYNshapeParams.LBDYNmodify02.text  = DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime LOCappData424 true)
              )
              if (findString DYNshapeParams.LBDYNmodify02.text DYNuiResourcesLabels[120]) != undefined then DYNshapeParams.LBDYNmodify02.text = "-"
            )
            else
            (
              DYNshapeParams.LBDYNmodify02.text  = ""
            )

            DYNshapeParams.BUDYNupdate.enabled = if DYNshapeParams.LBDYNmodel02.text != "" and DYNshapeParams.LBDYNstring02.text != "" then true else (if classof FUNshape.baseObject == LinkLeafshape then true else false)

            --- Surface breaklines from LandXML files cannot be updated
            if (stricmp (getFilenameType LOCappData424) ".xml") == 0 then DYNshapeParams.BUDYNupdate.enabled = false
          )
          else
          (
            DYNshapeParams.LBDYNmodel02.text   = DYNuiResourcesLabels[121]
            DYNshapeParams.LBDYNstring02.text  = DYNuiResourcesLabels[121]
            DYNshapeParams.LBDYNimported.text  = DYNuiResourcesLabels[121]
            DYNshapeParams.LBDYNsource.text    = DYNuiResourcesLabels[121]
            DYNshapeParams.LBDYNmodify02.text  = DYNuiResourcesLabels[121]
            DYNshapeParams.BUDYNupdate.enabled = false
          )
        )
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 21) height:100 pos:[4,7]
  label LBDYNpoints01 align:#left pos:[13,26]
  label LBDYNlength01 align:#left pos:[13,44]
  label LBDYNspline01 align:#left pos:[13,62]
  button BUDYNreport width:(DYNiniExplorerWidth - 39)    pos:[13,80]

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 21) height:56 pos:[4,112]
  label LBDYNpoints02 align:#left pos:[13,131]
  label LBDYNspline width:40 pos:[(DYNiniExplorerWidth - 106),131]
  spinner SPDYNspline "" align:#right type:#integer fieldwidth:25 height:12 pos:[(DYNiniExplorerWidth - 61),131]
  label LBDYNlength02 align:#left pos:[13,149]

  groupbox GBDYN03 width:(DYNiniExplorerWidth - 21) height:132 pos:[4,172]
  label LBDYNmodel01  align:#left pos:[13,191]
  label LBDYNmodel02  align:#left pos:[18,209] width:(DYNiniExplorerWidth - 39) height:38
  label LBDYNstring01 align:#left pos:[13,245]
  label LBDYNstring02 align:#left pos:[18,263] width:(DYNiniExplorerWidth - 39) height:38

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 21) height:38 pos:[4,308]
  label LBDYNimported align:#left pos:[18,326] width:(DYNiniExplorerWidth - 39)

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 21) height:74 pos:[4,351]
  label LBDYNsource align:#left pos:[13,369] width:(DYNiniExplorerWidth - 39)
  label LBDYNmodify01 align:#left pos:[13,387] width:(DYNiniExplorerWidth - 39)
  label LBDYNmodify02 align:#left pos:[18,405] width:(DYNiniExplorerWidth - 39)

  button BUDYNupdate width:(DYNiniExplorerWidth - 21)    pos:[4,432]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNshapeParams open do
  (
    LOCshape = $

    DYNshapeParams.title = DYNuiRolloutNames[17]

    GBDYN01.text         = DYNuiResourcesGroups[55]
    GBDYN02.text         = DYNuiResourcesGroups[56]
    GBDYN03.text         = DYNuiResourcesGroups[33]
    GBDYN04.text         = DYNuiResourcesGroups[34]
    GBDYN05.text         = DYNuiResourcesGroups[7]

    BUDYNreport.text     = DYNuiResourcesButtons[56]
    BUDYNupdate.text     = DYNuiResourcesButtons[14]

    LBDYNspline.text     = DYNuiResourcesLabels[192]
    LBDYNmodel01.text    = DYNuiResourcesLabels[51]
    LBDYNstring01.text   = DYNuiResourcesLabels[50]
    LBDYNmodify01.text   = DYNuiResourcesLabels[33]
  )

  on DYNshapeParams close do
  (
    LOCshape = undefined
  )

  on SPDYNspline changed arg do
  (
    DYNFUNshapeParams LOCshape arg
  )

  on BUDYNreport pressed do
  (
    DYNFUNmakeShapeReport LOCshape
  )

  on BUDYNupdate pressed do
  (
    if fileLinkMgr.isAnyLinked LOCshape then
    (
      DYNFUNloadVSPnodeCallBacks false
      with redraw off
      (
        for i = 1 to fileLinkMgr.numLinks do
        (
          fileLinkMgr.reLoad i showUI:true
        )
      )
      redrawViews()

      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()
      if not isDeleted LOCshape then select LOCshape else clearSelection()
    )
    else
    (
      APCFUNupdateImportedObjects #(LOCshape) true DYNtempPath
      APCFUNupdateAllPlacedObjectControllers()
    )
  )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCpvbT6PDwmTB+AINJcv1+/HUb89x8MVSMB
-- ktdqnxzF2RWvKcdESDpNpbNVWeqEPohbr+W1HNlwUM2iTxpmwbEchdiPo3wkoFFA
-- 8DK0Yye7WRgmWWU0V7k+BxHv5683Qqbx7e3y9/405yDm/QZX6ihAdEVoSCGlDs6z
-- npgt9RhscMwl+a1PplfU7EzJvt4jtv6TuJW13rPDm18CC6HvyfmzI/iR87ep+Ugx
-- dC20iFxvxV3adqb7NftknZpH/GpxZlwOLWHv7jaVTlyWb4WeuBCvGlhhlv4omWEx
-- bt8tMXmU6vcObCfOfgIOfATk4TByLfje4JvqpX0+Bsxt0qpsl9uX
-- -----END-SIGNATURE-----